<?php

namespace Inc\AdminCustomization;

class BasicAuth
{
    public function register() {
        add_action( 'init', array( $this, 'basic_auth' ) );
    }

    function is_login_page() {
        return in_array($GLOBALS['pagenow'], array('wp-login.php', 'wp-register.php'));
    }

    function basic_auth() {
        if($this->is_login_page()) {
            if ((!isset($_SERVER['PHP_AUTH_USER'])) || (!isset($_SERVER['PHP_AUTH_PW']))) {
                header('WWW-Authenticate: Basic realm="Secured Area"');
                header('HTTP/1.0 401 Unauthorized');
                echo 'Authorization Required.';
                exit;
            } else {
                if (is_wp_error(wp_authenticate_username_password(NULL, $_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW']))) {
                    header('WWW-Authenticate: Basic realm="Secured Area"');
                    header('HTTP/1.0 401 Unauthorized');
                    echo 'Authorization Required.';
                    exit;
                }
            }
        }
    }
}