<?php
/**
 * @package UnoxiPlugin
 */

namespace Inc\AdminCustomization;

class CustomAdminLogo {
	public function register() {
		add_action( 'wp_before_admin_bar_render', array( $this, 'wpb_custom_logo' ) );
	}

	function wpb_custom_logo() {
        $logo = PLUGIN_URL . 'assets/default.png';
        if(get_option('purple_wings_logo')) {
            $logo = '/wp-content/'.explode('/wp-content/', get_option('purple_wings_logo'))[1];
        }
		?>
        <style type="text/css">
            #wpadminbar #wp-admin-bar-wp-logo > .ab-item .ab-icon:before {
                color: rgba(0, 0, 0, 0) !important;
            }

            #wpadminbar>#wp-toolbar>#wp-admin-bar-root-default> #wp-admin-bar-wp-logo .ab-icon {
                height: 23px;
                width: 160px;
                background-image: url(<?php echo $logo; ?>) !important;
                background-size: contain;
                background-position: 0 0;
            }
        </style>
	<?php }
}
