<?php
/**
 * @package UnoxiPlugin
 */

namespace Inc\AdminCustomization;

class CustomAdminTheme {
	public function register() {
		add_action( 'wp_before_admin_bar_render', array( $this, 'custom_theme' ) );
	}

	function custom_theme() {
        $custom_theme = get_option('custom_theme_options');
        if(!$custom_theme) {
            update_option('custom_theme_options', DEFAULT_THEME);
            $custom_theme = DEFAULT_THEME;
        }
		?>
		<style>
            :root {
                <?php
                    foreach ($custom_theme as $theme_key => $theme_value) {
                        echo '--'.$theme_key.': '.$theme_value.';';
                    }
                 ?>
            }
		</style>
	<?php }
}
