<?php
/**
 * @package UnoxiPlugin
 */
namespace Inc\AdminCustomization;

class CustomLoginLogo
{
	public function register() {
		add_action( 'login_enqueue_scripts', array($this, 'my_login_logo') );
		add_filter( 'login_headerurl', array($this, 'my_login_logo_url') );
		add_filter( 'login_headertext', array($this, 'my_login_logo_url_title') );
	}

	function my_login_logo() {
        $logo = PLUGIN_URL . 'assets/default.png';
        if(get_option('purple_wings_logo')) {
            $logo = '/wp-content/'.explode('/wp-content/', get_option('purple_wings_logo'))[1];
        }
        ?>
		<style type="text/css">
            #login h1 a, .login h1 a {
                background-image: url(<?php echo $logo; ?>);
                height: 50px;
                width: 320px;
                background-size: 350px auto;
                background-repeat: no-repeat;
                padding-bottom: 30px;
            }
		</style>
	<?php }

	function my_login_logo_url() {
		return home_url();
	}

	function my_login_logo_url_title() {
		return 'DrZulasser dein online Zulasser!';
	}
}
