<?php
/**
 * @package UnoxiPlugin
 */

namespace Inc\AdminMenu;

class CustomAdminPage
{
    public function register()
    {
        add_option('purple_wings_logo', '');
        add_action('admin_menu', array($this, 'add_submenu'));
    }

    function add_submenu()
    {
        add_submenu_page('options-general.php', PLUGIN_NAME, PLUGIN_NAME, 'manage_options', strtolower(PLUGIN_NAME), array(
            $this,
            'admin_menu'
        ));
    }

    function admin_menu()
    {

        $message = '';
        $error = '';

        if(isset($_POST['installer'])) {
            $message = 'Plugins und Themes werden heruntergeladen ...';
            $url = 'http://repo.unoxi.de/purplewings-plugin/installer.tar';
            $file_name = basename($url);
            $path = str_replace( 'plugins/unoxi-plugin/', '', PLUGIN_PATH);
            $file = $path . $file_name;
            if (file_put_contents($file, file_get_contents($url))) {
                $this->untar($file, $path);
                unlink($file);
            }
        }

        if (isset($_FILES['logo']) && !empty($_FILES['logo']["name"])) {

            $target_dir_array = wp_upload_dir();
            $target_dir = $target_dir_array['path'];

            $target_file = $target_dir . str_replace(' ', '_', basename($_FILES['logo']['name']));

            $imageFileType = pathinfo($target_file, PATHINFO_EXTENSION);
            if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg"
                && $imageFileType != "gif") {
                $error = "Es sind nur JPG, JPEG, PNG & GIF erlaubt.";
            }

            if (empty($error)) {
                if (move_uploaded_file($_FILES['logo']['tmp_name'], $target_file)) {
                    $current_file = get_option('purple_wings_logo');
                    if (!empty($current_file) && $current_file !== $target_file) {
                        unlink($current_file);
                    }
                    update_option('purple_wings_logo', $target_file);
                    $message = 'Logo wurde erfolgreich geändert. (Ämderung nach neu laden sichtbar)';
                } else {
                    $error = 'Es gab einen Fehler beim hochladen der Datei!';
                }
            }
        }

        $custom_theme = get_option('custom_theme_options');

        $updated = false;
        foreach (DEFAULT_THEME as $theme_key => $theme_value) {
            if (isset($_POST[$theme_key]) && !empty($_POST[$theme_key])) {
                $custom_theme[$theme_key] = $_POST[$theme_key];
                $updated = true;
            }
        }
        if ($updated) {
            update_option('custom_theme_options', $custom_theme);
        }

        ?>
        <div class="wrap">
            <h1>Einstellungen › <?php echo PLUGIN_NAME; ?></h1>
            <?php if (!empty($message)) { ?>
                <div id="setting-error-settings_updated" class="notice notice-success settings-error is-dismissible">
                    <p><strong><?php echo $message; ?></strong></p>
                    <button type="button" class="notice-dismiss"><span class="screen-reader-text">Diese Meldung ausblenden.</span>
                    </button>
                </div>
            <?php } ?>
            <?php if (!empty($error)) { ?>
                <div id="setting-error-settings_updated" class="notice notice-error settings-error is-dismissible">
                    <p><strong><?php echo $error; ?></strong></p>
                    <button type="button" class="notice-dismiss"><span class="screen-reader-text">Diese Meldung ausblenden.</span>
                    </button>
                </div>
            <?php } ?>

            <form method="post" action="?page=<?php echo strtolower(PLUGIN_NAME); ?>" novalidate="novalidate"
                  enctype="multipart/form-data">
                <table class="form-table" role="presentation">
                    <tbody>
                    <tr>
                        <th scope="row"><label for="installer">Plugins / Theme herunterladen</label></th>
                        <td>
                            <input type="hidden" name="installer" value="true">
                            <p class="submit"><input type="submit" name="submit" id="submit"
                                                     class="button button-primary"
                                                     value="Jetzt herunterladen"></p>
                            <p class="description" id="logo-description">Alle Plugins und Themes aus dem Unoxi Paket
                                werden
                                runtergeladen. Die
                                aktivierung muss jedoch von Hand durchgeführt werden.</p>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </form>
            <br><br>

            <form method="post" action="?page=<?php echo strtolower(PLUGIN_NAME); ?>" novalidate="novalidate"
                  enctype="multipart/form-data">
                <table class="form-table" role="presentation">

                    <tbody>
                    <tr>
                        <th scope="row"><label for="logo">Admin-Panel / Login Logo</label></th>
                        <td>
                            <input name="logo" type="file" id="logo" accept=".jpg, .jpeg, .png, .gif">
                            <p class="description" id="logo-description">Das Logo muss eine Größe von 300 x 56 px
                                haben.</p>
                        </td>
                    </tr>
                    <?php foreach ($custom_theme as $theme_key => $theme_value) {
                        $label = ucwords(str_replace('-', ' ', $theme_key));
                        ?>
                        <tr>
                            <th scope="row"><label for="logo"><?php echo $label; ?></label></th>
                            <td>
                                <input name="<?php echo $theme_key; ?>" type="text" value="<?php echo $theme_value; ?>"
                                       class="my-color-field"
                                       data-default-color="<?php echo DEFAULT_THEME[$theme_key]; ?>"/>
                            </td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>

                <p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary"
                                         value="Änderungen speichern"></p>
            </form>
        </div>

        <script>
            var _URL = window.URL || window.webkitURL;
            let logo = document.getElementById("logo");
            logo.addEventListener("change", function (e) {
                var file, img;
                if ((file = this.files[0])) {
                    img = new Image();
                    var objectUrl = _URL.createObjectURL(file);
                    img.onload = function () {
                        if (this.width !== 300 || this.height !== 56) {
                            logo.value = null;
                            document.getElementById("logo-description").style.color = "#e74c3c";
                        } else {
                            document.getElementById("logo-description").style.color = "#2ecc71";
                        }
                        _URL.revokeObjectURL(objectUrl);
                    };
                    img.src = objectUrl;
                }
            });
        </script>
        <?php
    }

    function untar($file, $dest = "./") {
        if (!is_readable($file)) return false;

        $filesize = filesize($file);

        // Minimum 4 blocks
        if ($filesize <= 512*4) return false;

        if (!preg_match("/\/$/", $dest)) {
            // Force trailing slash
            $dest .= "/";
        }

        //Ensure write to destination
        if (!file_exists($dest)) {
            if (!mkdir($dest, 0777, true)) {
                return false;
            }
        }

        $fh = fopen($file, 'rb');
        $total = 0;
        while (false !== ($block = fread($fh, 512))) {

            $total += 512;
            $meta = array();
            // Extract meta data
            // http://www.mkssoftware.com/docs/man4/tar.4.asp
            $meta['filename'] = trim(substr($block, 0, 99));
            $meta['mode'] = octdec((int)trim(substr($block, 100, 8)));
            $meta['userid'] = octdec(substr($block, 108, 8));
            $meta['groupid'] = octdec(substr($block, 116, 8));
            $meta['filesize'] = octdec(substr($block, 124, 12));
            $meta['mtime'] = octdec(substr($block, 136, 12));
            $meta['header_checksum'] = octdec(substr($block, 148, 8));
            $meta['link_flag'] = octdec(substr($block, 156, 1));
            $meta['linkname'] = trim(substr($block, 157, 99));
            $meta['databytes'] = ($meta['filesize'] + 511) & ~511;

            if ($meta['link_flag'] == 5) {
                // Create folder
                mkdir($dest . $meta['filename'], 0777, true);
                chmod($dest . $meta['filename'], $meta['mode']);
            }

            if ($meta['databytes'] > 0) {
                $block = fread($fh, $meta['databytes']);
                // Extract data
                $data = substr($block, 0, $meta['filesize']);

                // Write data and set permissions
                if (false !== ($ftmp = fopen($dest . $meta['filename'], 'wb'))) {
                    fwrite($ftmp, $data);
                    fclose($ftmp);
                    touch($dest . $meta['filename'], $meta['mtime'], $meta['mtime']);

                    if ($meta['mode'] == 0744) $meta['mode'] = 0644;

                    chmod($dest . $meta['filename'], $meta['mode']);
                }
                $total += $meta['databytes'];
            }

            if ($total >= $filesize-1024) {
                return true;
            }
        }
        fclose($fh);
    }


}
