<?php
/**
 * @package UnoxiPlugin
 */
namespace Inc\Base;

class BasicAuth
{
    public function register() {
	    add_filter( 'determine_current_user', array($this, 'json_basic_auth_handler') );
	    add_filter( 'rest_authentication_errors', array($this, 'json_basic_auth_error') );
    }

	function json_basic_auth_handler( $user ) {
		global $wp_json_basic_auth_error;

		$wp_json_basic_auth_error = null;

		// Don't authenticate twice
		if ( ! empty( $user ) ) {
			return $user;
		}

		// Check that we're trying to authenticate
		if ( !isset( $_SERVER['PHP_AUTH_USER'] ) ) {
			return $user;
		}

		$username = $_SERVER['PHP_AUTH_USER'];
		$password = $_SERVER['PHP_AUTH_PW'];

		remove_filter( 'determine_current_user', 'json_basic_auth_handler' );

		$user = wp_authenticate( $username, $password );

		add_filter( 'determine_current_user', 'json_basic_auth_handler' );

		if ( is_wp_error( $user ) ) {
			$wp_json_basic_auth_error = $user;
			return null;
		}

		$wp_json_basic_auth_error = true;

		return $user->ID;
	}

	function json_basic_auth_error( $error ) {
		// Passthrough other errors
		if ( ! empty( $error ) ) {
			return $error;
		}

		global $wp_json_basic_auth_error;

		return $wp_json_basic_auth_error;
	}
}