<?php
/**
 * @package UnoxiPlugin
 */

namespace Inc\Base;

class CustomRest
{
    public function register()
    {
        add_action('rest_api_init', array($this, 'register_routes'));

    }

    function register_routes()
    {
        register_rest_route(
            'unoxi-plugin/v1',
            '/check',
            array(
                'methods' => 'GET',
                'callback' => array($this, 'callback_function'),
                'permission_callback' => '__return_true'
            ), true
        );
    }

    function callback_function($request)
    {
        return array(
            title => get_bloginfo('name'),
            description => get_bloginfo('description'),
            language => get_bloginfo('language'),
            plugins => $this->get_plugins(),
            themes => $this->get_themes());
    }

    function get_plugins()
    {
        include_once('wp-admin/includes/plugin.php');
        $all_plugins = get_plugins();

        $active_plugins = get_option('active_plugins');
        if(get_site_option( 'active_sitewide_plugins')) {
            foreach (wp_get_active_network_plugins() as $p) {
                $plugin = explode('/', $p);
                $active_plugins[] = $plugin[sizeof($plugin) - 2] . '/' . $plugin[sizeof($plugin) - 1];
            }
        }

        foreach ($all_plugins as $key => $value) {
            $is_active = (in_array($key, $active_plugins)) ? true : false;
            $plugins[] = array(
                'name' => $value['Name'],
                'author' => $value['Author'],
                'version' => $value['Version'],
                'status' => $is_active ? 'aktiv' : 'inaktiv',
            );
        }

        return $plugins;
    }

    function get_themes()
    {
        foreach (wp_get_themes() as $key => $value) {
            $is_active = wp_get_theme()->get('Name') === $value->get('Name') ? true : false;
            $themes[] = array(
                name => $value->get('Name'),
                author => $value->get('Author'),
                version => $value->get('Version'),
                status => $is_active ? 'aktiv' : 'inaktiv',
            );
        }

        return $themes;
    }

}