<?php
/**
 * @package UnoxiPlugin
 */
namespace Inc;

final class Init
{
    public static function get_services() 
    {
        return [
            Base\Activate::class,
            Base\Deactivate::class,
			AdminCustomization\CustomAdminTheme::class,
	        AdminMenu\CustomAdminPage::class,
            Base\Enqueue::class,
	        //Base\BasicAuth::class,
            Base\CustomRest::class,
	        AdminCustomization\CustomLoginLogo::class,
	        AdminCustomization\CustomAdminLogo::class,
	        AdminCustomization\CustomAdminFooterText::class,
            //AdminCustomization\BasicAuth::class,
	        Widgets\ServiceWidget::class,
        ];
    }

    public static function register_services() 
    {
        foreach(self::get_services() as $class) {
            $service = self::instantiate($class);
            if(method_exists($service, 'register')) {
                $service->register();
            }
        }
    }

    private static function instantiate($class) {
        return new $class();
    }
}
