<?php
/**
 * @package UnoxiPlugin
 */

namespace Inc\Widgets;

class ServiceWidget {

	public function register() {
		add_action( 'wp_dashboard_setup', array( $this, 'add_widget' ) );
	}

	function add_widget() {
		wp_add_dashboard_widget( 'service_widget', PLUGIN_NAME, array( $this, 'render_widget' ) );
	}

	function render_widget() {
		?>

        <div class="custom-row">
            <p>
                <b>Danke das Sie sich für <?php echo PLUGIN_NAME; ?> entschieden haben!</b>
                <br><br>
                Falls Sie Fragen haben oder weitere
                Beratung wünschen melden Sie sich über den <a href="<?php echo PLUGIN_URI; ?>" target="_blank">Link</a> bei uns.
            </p>
            <img id="plugin-logo" src="<?php echo PLUGIN_URL; ?>/assets/logo.png" alt="Plugin Logo">
        </div>

        <style>
            .custom-row {
                display: grid;
                grid-template-columns: 1fr 1fr;
            }
            #plugin-logo {
                width: 100%;
            }
        </style>
		<?php
	}
}
